import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/view/components/buttons/rounded_button.dart';
import 'package:viser_remit/view/components/divider/custom_divider.dart';
import 'package:viser_remit/view/components/text-form-field/custom_text_field.dart';

import '../../../../core/helper/string_format_helper.dart';
import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/transection/transection_controller.dart';
import '../../../components/bottom-sheet/bottom_sheet_header_row.dart';

class FilterSection extends StatelessWidget {
  final TransactionController controller;

  const FilterSection({super.key, required this.controller});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsetsDirectional.only(start: 5, end: 5, top: 20, bottom: 5),
      child: Column(
        children: [
          const BottomSheetHeaderRow(isShowCloseButton: false),
          Expanded(
            child: SingleChildScrollView(
              physics: const BouncingScrollPhysics(),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.transactionNumber.tr,
                          style: boldMediumLarge,
                        ),
                      ),
                      Expanded(
                          child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          const SizedBox(),
                          Flexible(
                            child: GestureDetector(
                                onTap: () {
                                  controller.setFilterSearch(false);
                                  controller.changeCurrentType(0);
                                  controller.changeCurrentRemark(0);
                                  controller.transactionController.text = '';
                                  controller.selectedRemark = '';
                                  controller.filterData();
                                  Get.back();
                                },
                                child: Text(
                                  MyStrings.clearFilter.tr,
                                  style: boldLarge,
                                )),
                          ),
                        ],
                      ))
                    ],
                  ),
                  const SizedBox(height: Dimensions.space10),
                  CustomTextField(
                    animatedLabel: true,
                    needOutlineBorder: true,
                    // isShowSuffixIcon: true,
                    isIcon: true,
                    labelText: MyStrings.pleaseEnterTransactionNumber,
                    controller: controller.transactionController,
                    focusNode: controller.transactionFocusNode,
                    textInputType: TextInputType.text,
                    validator: (value) {
                      if (value.toString().trim().isEmpty) {
                        return MyStrings.pleaseEnterTransactionNumber.tr;
                      } else {
                        return null;
                      }
                    },
                    onChanged: (value) {
                      return;
                    },
                  ),
                  const SizedBox(height: Dimensions.space30),
                  Text(MyStrings.type.tr, style: semiBoldMediumLarge),
                  const SizedBox(height: Dimensions.space10),
                  Column(
                    children: List.generate(
                        controller.type.length,
                        (index) => Column(
                              children: [
                                GestureDetector(
                                  onTap: () {
                                    controller.changeCurrentType(index);
                                  },
                                  child: Container(
                                    padding: const EdgeInsets.symmetric(vertical: 9),
                                    color: MyColor.colorWhite,
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(
                                          controller.type[index].tr,
                                          style: regularMediumLarge.copyWith(fontSize: 16),
                                        ),
                                        const Spacer(),
                                        Container(
                                          width: Dimensions.languageCircleSize,
                                          height: Dimensions.languageCircleSize,
                                          decoration: BoxDecoration(
                                            color: MyColor.colorWhite,
                                            shape: BoxShape.circle,
                                            border: Border.all(color: controller.currentType == index ? MyColor.primaryColor : MyColor.lightBodyText, width: 1.5),
                                          ),
                                          child: controller.currentType == index
                                              ? Column(
                                                  mainAxisAlignment: MainAxisAlignment.center,
                                                  children: [
                                                    Container(
                                                      width: 12,
                                                      height: 12,
                                                      decoration: const BoxDecoration(shape: BoxShape.circle, color: MyColor.primaryColor),
                                                    ),
                                                  ],
                                                )
                                              : const SizedBox.shrink(),
                                        )
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            )),
                  ),
                  const CustomDivider(),
                  Text(MyStrings.remark.tr, style: semiBoldMediumLarge),
                  const SizedBox(height: Dimensions.space10),
                  Column(
                    children: List.generate(controller.getRemarksList().length, (index) {
                      var item = controller.getRemarksList()[index];
                      return Column(
                        children: [
                          GestureDetector(
                            onTap: () {
                              controller.changeCurrentRemark(index);
                            },
                            child: Container(
                              padding: const EdgeInsets.symmetric(vertical: 9),
                              color: MyColor.colorWhite,
                              child: Row(
                                children: [
                                  Text(
                                    convertRemarkToTitleCase(item.remark.toString()).tr,
                                    style: regularMediumLarge.copyWith(fontSize: 16),
                                  ),
                                  const Spacer(),
                                  Container(
                                    width: Dimensions.languageCircleSize,
                                    height: Dimensions.languageCircleSize,
                                    decoration: BoxDecoration(
                                      color: MyColor.colorWhite,
                                      shape: BoxShape.circle,
                                      border: Border.all(color: controller.currentRemark == index ? MyColor.primaryColor : MyColor.lightBodyText, width: 1.5),
                                    ),
                                    child: controller.currentRemark == index
                                        ? Column(
                                            mainAxisAlignment: MainAxisAlignment.center,
                                            children: [
                                              Container(
                                                width: 12,
                                                height: 12,
                                                decoration: const BoxDecoration(shape: BoxShape.circle, color: MyColor.primaryColor),
                                              ),
                                            ],
                                          )
                                        : const SizedBox.shrink(),
                                  )
                                ],
                              ),
                            ),
                          ),
                          // controller.languageFlagList.length - 1 != index? const CustomDivider() : const SizedBox(height: 20,)
                        ],
                      );
                    }),
                  ),
                  const SizedBox(height: Dimensions.space15),
                  RoundedButton(
                    text: MyStrings.filterNow.tr,
                    press: () {
                      controller.filterData();
                      controller.setFilterSearch(true);
                      Get.back();
                    },
                  )
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
